/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.cobol.reader;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import za.co.absa.cobrix.cobol.internal.Logging;
import za.co.absa.cobrix.cobol.parser.Copybook;
import za.co.absa.cobrix.cobol.parser.Copybook$;
import za.co.absa.cobrix.cobol.parser.CopybookParser$;
import za.co.absa.cobrix.cobol.parser.ast.Primitive;
import za.co.absa.cobrix.cobol.parser.common.Constants$;
import za.co.absa.cobrix.cobol.parser.encoding.ASCII$;
import za.co.absa.cobrix.cobol.parser.encoding.EBCDIC$;
import za.co.absa.cobrix.cobol.parser.encoding.Encoding;
import za.co.absa.cobrix.cobol.parser.encoding.codepage.CodePage;
import za.co.absa.cobrix.cobol.parser.encoding.codepage.CodePage$;
import za.co.absa.cobrix.cobol.parser.headerparsers.RecordHeaderParser;
import za.co.absa.cobrix.cobol.parser.headerparsers.RecordHeaderParserFactory$;
import za.co.absa.cobrix.cobol.parser.recordformats.RecordFormat;
import za.co.absa.cobrix.cobol.parser.recordformats.RecordFormat$FixedBlock$;
import za.co.absa.cobrix.cobol.parser.recordformats.RecordFormat$VariableBlock$;
import za.co.absa.cobrix.cobol.reader.VarLenReader;
import za.co.absa.cobrix.cobol.reader.extractors.raw.FixedBlockParameters;
import za.co.absa.cobrix.cobol.reader.extractors.raw.FixedBlockParameters$;
import za.co.absa.cobrix.cobol.reader.extractors.raw.FixedBlockRawRecordExtractor;
import za.co.absa.cobrix.cobol.reader.extractors.raw.RawRecordContext;
import za.co.absa.cobrix.cobol.reader.extractors.raw.RawRecordExtractor;
import za.co.absa.cobrix.cobol.reader.extractors.raw.RawRecordExtractorFactory$;
import za.co.absa.cobrix.cobol.reader.extractors.raw.TextRecordExtractor;
import za.co.absa.cobrix.cobol.reader.extractors.raw.VarOccursRecordExtractor;
import za.co.absa.cobrix.cobol.reader.extractors.raw.VariableBlockVariableRecordExtractor;
import za.co.absa.cobrix.cobol.reader.extractors.record.RecordHandler;
import za.co.absa.cobrix.cobol.reader.index.IndexGenerator$;
import za.co.absa.cobrix.cobol.reader.index.entry.SparseIndexEntry;
import za.co.absa.cobrix.cobol.reader.iterator.VarLenHierarchicalIterator;
import za.co.absa.cobrix.cobol.reader.iterator.VarLenNestedIterator;
import za.co.absa.cobrix.cobol.reader.parameters.Bdw;
import za.co.absa.cobrix.cobol.reader.parameters.MultisegmentParameters;
import za.co.absa.cobrix.cobol.reader.parameters.ReaderParameters;
import za.co.absa.cobrix.cobol.reader.recordheader.RecordHeaderDecoder;
import za.co.absa.cobrix.cobol.reader.recordheader.RecordHeaderDecoderBdw;
import za.co.absa.cobrix.cobol.reader.recordheader.RecordHeaderDecoderRdw;
import za.co.absa.cobrix.cobol.reader.recordheader.RecordHeaderParameters;
import za.co.absa.cobrix.cobol.reader.schema.CobolSchema;
import za.co.absa.cobrix.cobol.reader.stream.SimpleStream;
import za.co.absa.cobrix.cobol.reader.validator.ReaderParametersValidator$;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\r\u001a\u0001\u0019B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005i\u0001\t\r\t\u0015a\u0003j\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d9\bA1A\u0005\u0012aDaa \u0001!\u0002\u0013I\b\"CA\u0001\u0001\t\u0007I\u0011CA\u0002\u0011!\t)\u0002\u0001Q\u0001\n\u0005\u0015\u0001bBA\f\u0001\u0011E\u0011\u0011\u0004\u0005\u0007\u0003'\u0002A\u0011\t=\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA5\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!a,\u0001\t\u0013\t\t\fC\u0004\u00028\u0002!I!!/\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAs\u0001\u0011%\u00111\u0001\u0005\b\u0003O\u0004A\u0011BA\u0002\u0011\u001d\tI\u000f\u0001C\u0005\u0003W\u0014!CV1s\u0019\u0016tg*Z:uK\u0012\u0014V-\u00193fe*\u0011!dG\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005qi\u0012!B2pE>d'B\u0001\u0010 \u0003\u0019\u0019wN\u0019:jq*\u0011\u0001%I\u0001\u0005C\n\u001c\u0018M\u0003\u0002#G\u0005\u00111m\u001c\u0006\u0002I\u0005\u0011!0Y\u0002\u0001+\t9sl\u0005\u0003\u0001Q1\u0012\u0004CA\u0015+\u001b\u0005I\u0012BA\u0016\u001a\u000511\u0016M\u001d'f]J+\u0017\rZ3s!\ti\u0003'D\u0001/\u0015\ty3$\u0001\u0005j]R,'O\\1m\u0013\t\tdFA\u0004M_\u001e<\u0017N\\4\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u0019M+'/[1mSj\f'\r\\3\u0002!\r|\u0007/\u001f2p_.\u001cuN\u001c;f]R\u001c\bc\u0001\u001eC\u000b:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}\u0015\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005\u0005#\u0014a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u00131aU3r\u0015\t\tE\u0007\u0005\u0002G\u0015:\u0011q\t\u0013\t\u0003yQJ!!\u0013\u001b\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013R\n\u0001C]3bI\u0016\u0014\bK]8qKJ$\u0018.Z:\u0011\u0005=\u0013V\"\u0001)\u000b\u0005EK\u0012A\u00039be\u0006lW\r^3sg&\u00111\u000b\u0015\u0002\u0011%\u0016\fG-\u001a:QCJ\fW.\u001a;feN\fq\u0001[1oI2,'\u000fE\u0002W7vk\u0011a\u0016\u0006\u00031f\u000baA]3d_J$'B\u0001.\u001a\u0003))\u0007\u0010\u001e:bGR|'o]\u0005\u00039^\u0013QBU3d_J$\u0007*\u00198eY\u0016\u0014\bC\u00010`\u0019\u0001!Q\u0001\u0019\u0001C\u0002\u0005\u0014\u0011\u0001V\t\u0003E\u0016\u0004\"aM2\n\u0005\u0011$$a\u0002(pi\"Lgn\u001a\t\u0003g\u0019L!a\u001a\u001b\u0003\u0007\u0005s\u00170\u0001\u0006fm&$WM\\2fIE\u00022A[7^\u001b\u0005Y'B\u000175\u0003\u001d\u0011XM\u001a7fGRL!A\\6\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtD\u0003B9ukZ$\"A]:\u0011\u0007%\u0002Q\fC\u0003i\u000b\u0001\u000f\u0011\u000eC\u00039\u000b\u0001\u0007\u0011\bC\u0003N\u000b\u0001\u0007a\nC\u0003U\u000b\u0001\u0007Q+A\u0006d_\n|GnU2iK6\fW#A=\u0011\u0005ilX\"A>\u000b\u0005qL\u0012AB:dQ\u0016l\u0017-\u0003\u0002\u007fw\nY1i\u001c2pYN\u001b\u0007.Z7b\u00031\u0019wNY8m'\u000eDW-\\1!\u0003I\u0011XmY8sI\"+\u0017\rZ3s!\u0006\u00148/\u001a:\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u000eQ\u0016\fG-\u001a:qCJ\u001cXM]:\u000b\u0007\u0005=1$\u0001\u0004qCJ\u001cXM]\u0005\u0005\u0003'\tIA\u0001\nSK\u000e|'\u000f\u001a%fC\u0012,'\u000fU1sg\u0016\u0014\u0018a\u0005:fG>\u0014H\rS3bI\u0016\u0014\b+\u0019:tKJ\u0004\u0013a\u0004:fG>\u0014H-\u0012=ue\u0006\u001cGo\u001c:\u0015\u0011\u0005m\u0011QFA\u001c\u0003\u000f\u0002RaMA\u000f\u0003CI1!a\b5\u0005\u0019y\u0005\u000f^5p]B!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(e\u000b1A]1x\u0013\u0011\tY#!\n\u0003%I\u000bwOU3d_J$W\t\u001f;sC\u000e$xN\u001d\u0005\b\u0003_Q\u0001\u0019AA\u0019\u0003Q\u0019H/\u0019:uS:<'+Z2pe\u0012tU/\u001c2feB\u00191'a\r\n\u0007\u0005UBG\u0001\u0003M_:<\u0007bBA\u001d\u0015\u0001\u0007\u00111H\u0001\u000bE&t\u0017M]=ECR\f\u0007\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005\u0013$\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003\u000b\nyD\u0001\u0007TS6\u0004H.Z*ue\u0016\fW\u000eC\u0004\u0002J)\u0001\r!a\u0013\u0002\u0011\r|\u0007/\u001f2p_.\u0004B!!\u0014\u0002P5\u0011\u0011QB\u0005\u0005\u0003#\niA\u0001\u0005D_BL(m\\8l\u000399W\r^\"pE>d7k\u00195f[\u0006\fQbZ3u%\u0016\u001cwN\u001d3TSj,WCAA-!\r\u0019\u00141L\u0005\u0004\u0003;\"$aA%oi\u00069\u0012n]%oI\u0016Dx)\u001a8fe\u0006$\u0018n\u001c8OK\u0016$W\rZ\u000b\u0003\u0003G\u00022aMA3\u0013\r\t9\u0007\u000e\u0002\b\u0005>|G.Z1o\u00039I7O\u00153x\u0005&<WI\u001c3jC:\f\u0011cZ3u%\u0016\u001cwN\u001d3Ji\u0016\u0014\u0018\r^8s))\ty'a\u001e\u0002z\u0005u\u0014\u0011\u0011\t\u0006u\u0005E\u0014QO\u0005\u0004\u0003g\"%\u0001C%uKJ\fGo\u001c:\u0011\u0007i\u0012U\rC\u0004\u0002:=\u0001\r!a\u000f\t\u000f\u0005mt\u00021\u0001\u00022\u0005\u00112\u000f^1si&twMR5mK>3gm]3u\u0011\u001d\tyh\u0004a\u0001\u00033\n!BZ5mK:+XNY3s\u0011\u001d\t\u0019i\u0004a\u0001\u0003c\t1c\u001d;beRLgn\u001a*fG>\u0014H-\u00138eKb\fQbZ3oKJ\fG/Z%oI\u0016DH\u0003CAE\u0003S\u000bY+!,\u0011\r\u0005-\u0015QSAM\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003'#\u0014AC2pY2,7\r^5p]&!\u0011qSAG\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\t\u0005m\u0015QU\u0007\u0003\u0003;SA!a(\u0002\"\u0006)QM\u001c;ss*\u0019\u00111U\r\u0002\u000b%tG-\u001a=\n\t\u0005\u001d\u0016Q\u0014\u0002\u0011'B\f'o]3J]\u0012,\u00070\u00128uefDq!!\u000f\u0011\u0001\u0004\tY\u0004C\u0004\u0002\u0000A\u0001\r!!\u0017\t\u000f\u0005%\u0004\u00031\u0001\u0002d\u0005aAn\\1e\u0007>\u0004\u0018PQ8pWR\u0019\u00110a-\t\r\u0005U\u0016\u00031\u0001:\u0003A\u0019w\u000e]=C_>\\7i\u001c8uK:$8/A\u000edQ\u0016\u001c7.\u00138qkR\f%oZ;nK:$8OV1mS\u0012LG/\u001f\u000b\u0003\u0003w\u00032aMA_\u0013\r\ty\f\u000e\u0002\u0005+:LG/\u0001\bhKR\u001c\u0006\u000f\\5u'&TX-\u0014\"\u0016\u0005\u0005\u0015\u0007#B\u001a\u0002\u001e\u0005e\u0013aC4fi\u000e{G-\u001a)bO\u0016$b!a3\u0002\\\u0006}\u0007\u0003BAg\u0003/l!!a4\u000b\t\u0005E\u00171[\u0001\tG>$W\r]1hK*!\u0011Q[A\u0007\u0003!)gnY8eS:<\u0017\u0002BAm\u0003\u001f\u0014\u0001bQ8eKB\u000bw-\u001a\u0005\u0007\u0003;$\u0002\u0019A#\u0002\u0019\r|G-\u001a)bO\u0016t\u0015-\\3\t\u000f\u0005\u0005H\u00031\u0001\u0002d\u0006i1m\u001c3f!\u0006<Wm\u00117bgN\u0004BaMA\u000f\u000b\u0006)r-\u001a;SK\u000e|'\u000f\u001a%fC\u0012,'\u000fU1sg\u0016\u0014\u0018\u0001H4fi\u0012+g-Y;miJ+7m\u001c:e\u0011\u0016\fG-\u001a:QCJ\u001cXM]\u0001\u0011O\u0016$(k\\8u'\u0016<W.\u001a8u\u0013\u0012,\u0012!\u0012")
public class VarLenNestedReader<T>
extends VarLenReader
implements Logging {
    private final ReaderParameters readerProperties;
    private final RecordHandler<T> handler;
    private final ClassTag<T> evidence$1;
    private final CobolSchema cobolSchema;
    private final RecordHeaderParser recordHeaderParser;
    private transient Logger za$co$absa$cobrix$cobol$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public Logger za$co$absa$cobrix$cobol$internal$Logging$$log_() {
        return this.za$co$absa$cobrix$cobol$internal$Logging$$log_;
    }

    @Override
    public void za$co$absa$cobrix$cobol$internal$Logging$$log__$eq(Logger x$1) {
        this.za$co$absa$cobrix$cobol$internal$Logging$$log_ = x$1;
    }

    public CobolSchema cobolSchema() {
        return this.cobolSchema;
    }

    public RecordHeaderParser recordHeaderParser() {
        return this.recordHeaderParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<RawRecordExtractor> recordExtractor(long startingRecordNumber, SimpleStream binaryData, Copybook copybook) {
        RecordHeaderParameters rdwParams = new RecordHeaderParameters(this.readerProperties.isRdwBigEndian(), this.readerProperties.rdwAdjustment());
        RecordHeaderDecoderRdw rdwDecoder = new RecordHeaderDecoderRdw(rdwParams);
        Option<Bdw> bdwOpt = this.readerProperties.bdw();
        Option bdwParamsOpt = bdwOpt.map((Function1 & Serializable & scala.Serializable)bdw -> new RecordHeaderParameters(bdw.isBigEndian(), bdw.adjustment()));
        Option bdwDecoderOpt = bdwParamsOpt.map((Function1 & Serializable & scala.Serializable)bdwParams -> new RecordHeaderDecoderBdw((RecordHeaderParameters)bdwParams));
        RawRecordContext reParams = new RawRecordContext(startingRecordNumber, binaryData, copybook, rdwDecoder, (RecordHeaderDecoder)bdwDecoderOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> rdwDecoder), this.readerProperties.reAdditionalInfo());
        boolean bl = false;
        Option<String> option = null;
        Option<String> option2 = this.readerProperties.recordExtractor();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String recordExtractorClass = (String)some.value();
            return new Some((Object)RawRecordExtractorFactory$.MODULE$.createRecordHeaderParser(recordExtractorClass, reParams));
        }
        if (None$.MODULE$.equals(option2)) {
            bl = true;
            option = option2;
            if (this.readerProperties.isText()) {
                return new Some((Object)new TextRecordExtractor(reParams));
            }
        }
        if (bl) {
            RecordFormat recordFormat = this.readerProperties.recordFormat();
            RecordFormat$FixedBlock$ recordFormat$FixedBlock$ = RecordFormat$FixedBlock$.MODULE$;
            if (!(recordFormat != null ? !recordFormat.equals(recordFormat$FixedBlock$) : recordFormat$FixedBlock$ != null)) {
                FixedBlockParameters fbParams = new FixedBlockParameters(this.readerProperties.recordLength(), ((Bdw)bdwOpt.get()).blockLength(), ((Bdw)bdwOpt.get()).recordsPerBlock());
                FixedBlockParameters$.MODULE$.validate(fbParams);
                return new Some((Object)new FixedBlockRawRecordExtractor(reParams, fbParams));
            }
        }
        if (bl) {
            RecordFormat recordFormat = this.readerProperties.recordFormat();
            RecordFormat$VariableBlock$ recordFormat$VariableBlock$ = RecordFormat$VariableBlock$.MODULE$;
            if (recordFormat == null) {
                if (recordFormat$VariableBlock$ == null) return new Some((Object)new VariableBlockVariableRecordExtractor(reParams));
            } else if (recordFormat.equals(recordFormat$VariableBlock$)) {
                return new Some((Object)new VariableBlockVariableRecordExtractor(reParams));
            }
        }
        if (bl && this.readerProperties.variableSizeOccurs() && this.readerProperties.recordHeaderParser().isEmpty() && !this.readerProperties.isRecordSequence() && this.readerProperties.lengthFieldName().isEmpty()) {
            return new Some((Object)new VarOccursRecordExtractor(reParams));
        }
        if (!bl) throw new MatchError(option2);
        return None$.MODULE$;
    }

    @Override
    public CobolSchema getCobolSchema() {
        return this.cobolSchema();
    }

    @Override
    public int getRecordSize() {
        return this.cobolSchema().copybook().getRecordSize();
    }

    @Override
    public boolean isIndexGenerationNeeded() {
        return (this.readerProperties.lengthFieldName().isEmpty() || this.readerProperties.isRecordSequence()) && this.readerProperties.isIndexGenerationNeeded();
    }

    @Override
    public boolean isRdwBigEndian() {
        return this.readerProperties.isRdwBigEndian();
    }

    @Override
    public Iterator<Seq<Object>> getRecordIterator(SimpleStream binaryData, long startingFileOffset, int fileNumber, long startingRecordIndex) {
        return this.cobolSchema().copybook().isHierarchical() ? new VarLenHierarchicalIterator<T>(this.cobolSchema().copybook(), binaryData, this.readerProperties, this.recordHeaderParser(), this.recordExtractor(startingRecordIndex, binaryData, this.cobolSchema().copybook()), fileNumber, startingRecordIndex, startingFileOffset, this.handler, this.evidence$1) : new VarLenNestedIterator<T>(this.cobolSchema().copybook(), binaryData, this.readerProperties, this.recordHeaderParser(), this.recordExtractor(startingRecordIndex, binaryData, this.cobolSchema().copybook()), fileNumber, startingRecordIndex, startingFileOffset, this.cobolSchema().segmentIdPrefix(), this.handler, this.evidence$1);
    }

    @Override
    public ArrayBuffer<SparseIndexEntry> generateIndex(SimpleStream binaryData, int fileNumber, boolean isRdwBigEndian) {
        ArrayBuffer<SparseIndexEntry> arrayBuffer;
        boolean bl;
        int recordSize = this.cobolSchema().getRecordSize();
        Option<Object> inputSplitSizeRecords = this.readerProperties.inputSplitRecords();
        Option<Object> inputSplitSizeMB = this.getSplitSizeMB();
        if (inputSplitSizeRecords.isDefined()) {
            if (BoxesRunTime.unboxToInt((Object)inputSplitSizeRecords.get()) < 1 || BoxesRunTime.unboxToInt((Object)inputSplitSizeRecords.get()) > 1000000000) {
                throw new IllegalArgumentException(new StringBuilder(62).append("Invalid input split size. The requested number of records is ").append(inputSplitSizeRecords.get()).append(".").toString());
            }
            this.logger().info(new StringBuilder(27).append("Input split size = ").append(inputSplitSizeRecords.get()).append(" records").toString());
        } else if (inputSplitSizeMB.nonEmpty()) {
            if (BoxesRunTime.unboxToInt((Object)inputSplitSizeMB.get()) < 1 || BoxesRunTime.unboxToInt((Object)inputSplitSizeMB.get()) > 2000) {
                throw new IllegalArgumentException(new StringBuilder(32).append("Invalid input split size of ").append(inputSplitSizeMB.get()).append(" MB.").toString());
            }
            this.logger().info(new StringBuilder(22).append("Input split size = ").append(inputSplitSizeMB.get()).append(" MB").toString());
        }
        Copybook copybook = this.cobolSchema().copybook();
        Option<Primitive> segmentIdField = ReaderParametersValidator$.MODULE$.getSegmentIdField(this.readerProperties.multisegment(), copybook);
        String segmentIdValue = this.getRootSegmentId();
        Option<MultisegmentParameters> option = this.readerProperties.multisegment();
        if (option instanceof Some) {
            Some some = (Some)option;
            MultisegmentParameters params = (MultisegmentParameters)some.value();
            bl = params.segmentLevelIds().nonEmpty() || params.fieldParentMap().nonEmpty();
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        boolean isHierarchical = bl;
        Option<Primitive> option2 = segmentIdField;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Primitive field = (Primitive)some.value();
            arrayBuffer = IndexGenerator$.MODULE$.sparseIndexGenerator(fileNumber, binaryData, isRdwBigEndian, this.recordHeaderParser(), this.recordExtractor(0L, binaryData, copybook), inputSplitSizeRecords, inputSplitSizeMB, (Option<Copybook>)new Some((Object)copybook), (Option<Primitive>)new Some((Object)field), isHierarchical, segmentIdValue);
        } else if (None$.MODULE$.equals(option2)) {
            arrayBuffer = IndexGenerator$.MODULE$.sparseIndexGenerator(fileNumber, binaryData, isRdwBigEndian, this.recordHeaderParser(), this.recordExtractor(0L, binaryData, copybook), inputSplitSizeRecords, inputSplitSizeMB, (Option<Copybook>)None$.MODULE$, (Option<Primitive>)None$.MODULE$, isHierarchical, IndexGenerator$.MODULE$.sparseIndexGenerator$default$11());
        } else {
            throw new MatchError(option2);
        }
        return arrayBuffer;
    }

    private CobolSchema loadCopyBook(Seq<String> copyBookContents) {
        Product encoding = this.readerProperties.isEbcdic() ? EBCDIC$.MODULE$ : ASCII$.MODULE$;
        List segmentRedefines = (List)this.readerProperties.multisegment().map((Function1 & Serializable & scala.Serializable)r -> (List)r.segmentIdRedefineMap().values().toList().distinct()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Map fieldParentMap = (Map)this.readerProperties.multisegment().map((Function1 & Serializable & scala.Serializable)r -> r.fieldParentMap()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        CodePage codePage = this.getCodePage(this.readerProperties.ebcdicCodePage(), this.readerProperties.ebcdicCodePageClass());
        Charset asciiCharset = this.readerProperties.asciiCharset().isEmpty() ? StandardCharsets.US_ASCII : Charset.forName(this.readerProperties.asciiCharset());
        Copybook schema = copyBookContents.size() == 1 ? CopybookParser$.MODULE$.parseTree((Encoding)encoding, (String)copyBookContents.head(), this.readerProperties.dropGroupFillers(), this.readerProperties.dropValueFillers(), (Seq<String>)segmentRedefines, (Map<String, String>)fieldParentMap, this.readerProperties.stringTrimmingPolicy(), this.readerProperties.commentPolicy(), this.readerProperties.improvedNullDetection(), codePage, asciiCharset, this.readerProperties.isUtf16BigEndian(), this.readerProperties.floatingPointFormat(), this.readerProperties.nonTerminals(), this.readerProperties.occursMappings(), this.readerProperties.debugFieldsPolicy()) : Copybook$.MODULE$.merge((Seq<Copybook>)((Seq)copyBookContents.map((Function1 & Serializable & scala.Serializable)cpb -> CopybookParser$.MODULE$.parseTree((Encoding)encoding, (String)cpb, $this.readerProperties.dropGroupFillers(), $this.readerProperties.dropValueFillers(), (Seq<String>)segmentRedefines, (Map<String, String>)fieldParentMap, $this.readerProperties.stringTrimmingPolicy(), $this.readerProperties.commentPolicy(), $this.readerProperties.improvedNullDetection(), codePage, asciiCharset, $this.readerProperties.isUtf16BigEndian(), $this.readerProperties.floatingPointFormat(), $this.readerProperties.nonTerminals(), $this.readerProperties.occursMappings(), $this.readerProperties.debugFieldsPolicy()), Seq$.MODULE$.canBuildFrom())));
        int segIdFieldCount = BoxesRunTime.unboxToInt((Object)this.readerProperties.multisegment().map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)VarLenNestedReader.$anonfun$loadCopyBook$6(p))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        String segmentIdPrefix = (String)this.readerProperties.multisegment().map((Function1 & Serializable & scala.Serializable)p -> p.segmentIdPrefix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new CobolSchema(schema, this.readerProperties.schemaPolicy(), this.readerProperties.inputFileNameColumn(), this.readerProperties.generateRecordId(), segIdFieldCount, segmentIdPrefix);
    }

    private void checkInputArgumentsValidity() {
        if (this.readerProperties.startOffset() < 0) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Invalid record start offset = ").append(this.readerProperties.startOffset()).append(". A record start offset cannot be negative.").toString());
        }
        if (this.readerProperties.endOffset() < 0) {
            throw new IllegalArgumentException(new StringBuilder(69).append("Invalid record end offset = ").append(this.readerProperties.endOffset()).append(". A record end offset cannot be negative.").toString());
        }
    }

    private Option<Object> getSplitSizeMB() {
        return this.readerProperties.inputSplitSizeMB().isDefined() ? this.readerProperties.inputSplitSizeMB() : this.readerProperties.hdfsDefaultBlockSize();
    }

    private CodePage getCodePage(String codePageName, Option<String> codePageClass) {
        CodePage codePage;
        Option<String> option = codePageClass;
        if (option instanceof Some) {
            Some some = (Some)option;
            String c = (String)some.value();
            codePage = CodePage$.MODULE$.getCodePageByClass(c);
        } else if (None$.MODULE$.equals(option)) {
            codePage = CodePage$.MODULE$.getCodePageByName(codePageName);
        } else {
            throw new MatchError(option);
        }
        return codePage;
    }

    private RecordHeaderParser getRecordHeaderParser() {
        RecordHeaderParser recordHeaderParser;
        int adjustment1 = this.readerProperties.isRdwPartRecLength() ? -4 : 0;
        int adjustment2 = this.readerProperties.rdwAdjustment();
        Option<String> option = this.readerProperties.recordHeaderParser();
        if (option instanceof Some) {
            Some some = (Some)option;
            String customRecordParser = (String)some.value();
            recordHeaderParser = RecordHeaderParserFactory$.MODULE$.createRecordHeaderParser(customRecordParser, this.cobolSchema().getRecordSize(), this.readerProperties.fileStartOffset(), this.readerProperties.fileEndOffset(), adjustment1 + adjustment2);
        } else if (None$.MODULE$.equals(option)) {
            recordHeaderParser = this.getDefaultRecordHeaderParser();
        } else {
            throw new MatchError(option);
        }
        RecordHeaderParser rhp = recordHeaderParser;
        this.readerProperties.rhpAdditionalInfo().foreach((Function1 & Serializable & scala.Serializable)additionalInfo -> {
            rhp.onReceiveAdditionalInfo(additionalInfo);
            return BoxedUnit.UNIT;
        });
        return rhp;
    }

    private RecordHeaderParser getDefaultRecordHeaderParser() {
        int adjustment1 = this.readerProperties.isRdwPartRecLength() ? -4 : 0;
        int adjustment2 = this.readerProperties.rdwAdjustment();
        return this.readerProperties.isRecordSequence() ? (this.isRdwBigEndian() ? RecordHeaderParserFactory$.MODULE$.createRecordHeaderParser(Constants$.MODULE$.RhRdwBigEndian(), this.cobolSchema().getRecordSize(), this.readerProperties.fileStartOffset(), this.readerProperties.fileEndOffset(), adjustment1 + adjustment2) : RecordHeaderParserFactory$.MODULE$.createRecordHeaderParser(Constants$.MODULE$.RhRdwLittleEndian(), this.cobolSchema().getRecordSize(), this.readerProperties.fileStartOffset(), this.readerProperties.fileEndOffset(), adjustment1 + adjustment2)) : RecordHeaderParserFactory$.MODULE$.createRecordHeaderParser(Constants$.MODULE$.RhRdwFixedLength(), this.cobolSchema().getRecordSize(), this.readerProperties.fileStartOffset(), this.readerProperties.fileEndOffset(), 0);
    }

    private String getRootSegmentId() {
        String string;
        Option<MultisegmentParameters> option = this.readerProperties.multisegment();
        if (option instanceof Some) {
            Some some = (Some)option;
            MultisegmentParameters m = (MultisegmentParameters)some.value();
            string = m.fieldParentMap().nonEmpty() && m.segmentIdRedefineMap().nonEmpty() ? (String)this.cobolSchema().copybook().getRootSegmentIds(m.segmentIdRedefineMap(), m.fieldParentMap()).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") : (String)m.segmentLevelIds().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public static final /* synthetic */ int $anonfun$loadCopyBook$6(MultisegmentParameters p) {
        return p.segmentLevelIds().size();
    }

    public VarLenNestedReader(Seq<String> copybookContents, ReaderParameters readerProperties, RecordHandler<T> handler, ClassTag<T> evidence$1) {
        this.readerProperties = readerProperties;
        this.handler = handler;
        this.evidence$1 = evidence$1;
        Logging.$init$(this);
        this.cobolSchema = this.loadCopyBook(copybookContents);
        this.recordHeaderParser = this.getRecordHeaderParser();
        this.checkInputArgumentsValidity();
    }
}

