/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.cobol.reader.index;

import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import za.co.absa.cobrix.cobol.internal.Logging;
import za.co.absa.cobrix.cobol.parser.Copybook;
import za.co.absa.cobrix.cobol.parser.ast.Primitive;
import za.co.absa.cobrix.cobol.parser.headerparsers.RecordHeaderParser;
import za.co.absa.cobrix.cobol.parser.headerparsers.RecordMetadata;
import za.co.absa.cobrix.cobol.reader.common.Constants$;
import za.co.absa.cobrix.cobol.reader.extractors.raw.RawRecordExtractor;
import za.co.absa.cobrix.cobol.reader.index.entry.SparseIndexEntry;
import za.co.absa.cobrix.cobol.reader.stream.SimpleStream;

public final class IndexGenerator$
implements Logging {
    public static IndexGenerator$ MODULE$;
    private transient Logger za$co$absa$cobrix$cobol$internal$Logging$$log_;

    static {
        new IndexGenerator$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public Logger za$co$absa$cobrix$cobol$internal$Logging$$log_() {
        return this.za$co$absa$cobrix$cobol$internal$Logging$$log_;
    }

    @Override
    public void za$co$absa$cobrix$cobol$internal$Logging$$log__$eq(Logger x$1) {
        this.za$co$absa$cobrix$cobol$internal$Logging$$log_ = x$1;
    }

    public ArrayBuffer<SparseIndexEntry> sparseIndexGenerator(int fileId, SimpleStream dataStream, boolean isRdwBigEndian, RecordHeaderParser recordHeaderParser, Option<RawRecordExtractor> recordExtractor, Option<Object> recordsPerIndexEntry, Option<Object> sizePerIndexEntryMB, Option<Copybook> copybook, Option<Primitive> segmentField, boolean isHierarchical, String rootSegmentId) {
        ArrayBuffer index;
        block15: {
            boolean isReallyHierarchical;
            String rootRecordId;
            block14: {
                List rootSegmentIds = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(rootSegmentId)).split(','))).toList();
                long byteIndex = 0L;
                index = new ArrayBuffer();
                rootRecordId = "";
                int recordsInChunk = 0;
                long bytesInChunk = 0L;
                int recordIndex = 0;
                isReallyHierarchical = copybook.nonEmpty() && segmentField.nonEmpty() && isHierarchical;
                boolean isSplitBySize = recordsPerIndexEntry.isEmpty() && sizePerIndexEntryMB.nonEmpty();
                Function2<Object, Object, Object> needSplit = this.getSplitCondition(recordsPerIndexEntry, sizePerIndexEntryMB);
                SparseIndexEntry indexEntry = new SparseIndexEntry(0L, -1L, fileId, recordIndex);
                index.$plus$eq((Object)indexEntry);
                boolean endOfFileReached = false;
                while (!endOfFileReached) {
                    Tuple3 tuple3;
                    byte[] record = null;
                    Option<RawRecordExtractor> option = recordExtractor;
                    if (option instanceof Some) {
                        boolean bl;
                        Some some = (Some)option;
                        RawRecordExtractor extractor = (RawRecordExtractor)some.value();
                        long offset0 = extractor.offset();
                        if (extractor.hasNext()) {
                            record = (byte[])extractor.next();
                            bl = true;
                        } else {
                            bl = false;
                        }
                        boolean isValid = bl;
                        long offset1 = extractor.offset();
                        long recordLength = offset1 - offset0;
                        tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)recordLength), (Object)BoxesRunTime.boxToBoolean((boolean)isValid), (Object)BoxesRunTime.boxToBoolean((boolean)extractor.hasNext()));
                    } else if (None$.MODULE$.equals(option)) {
                        long recordSize;
                        int headerSize = recordHeaderParser.getHeaderLength();
                        byte[] headerBytes = dataStream.next(headerSize);
                        RecordMetadata recordMetadata = recordHeaderParser.getRecordMetadata(headerBytes, dataStream.offset(), dataStream.size(), recordIndex);
                        if (recordMetadata.recordLength() > 0) {
                            record = dataStream.next(recordMetadata.recordLength());
                        }
                        boolean hasMoreRecords = (recordSize = dataStream.offset() - byteIndex) > 0L && !dataStream.isEndOfStream();
                        tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)recordSize), (Object)BoxesRunTime.boxToBoolean((boolean)recordMetadata.isValid()), (Object)BoxesRunTime.boxToBoolean((boolean)hasMoreRecords));
                    } else {
                        throw new MatchError(option);
                    }
                    Tuple3 tuple32 = tuple3;
                    if (tuple32 == null) {
                        throw new MatchError((Object)tuple32);
                    }
                    long recordSize = BoxesRunTime.unboxToLong((Object)tuple32._1());
                    boolean isValid = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
                    boolean hasMoreRecords = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
                    long l = recordSize;
                    Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToBoolean((boolean)isValid), (Object)BoxesRunTime.boxToBoolean((boolean)hasMoreRecords));
                    Tuple3 tuple34 = tuple33;
                    long recordSize2 = BoxesRunTime.unboxToLong((Object)tuple34._1());
                    boolean isValid2 = BoxesRunTime.unboxToBoolean((Object)tuple34._2());
                    boolean hasMoreRecords2 = BoxesRunTime.unboxToBoolean((Object)tuple34._3());
                    if (!hasMoreRecords2) {
                        endOfFileReached = true;
                    } else if (isValid2) {
                        String curSegmentId;
                        if (isReallyHierarchical && rootRecordId.isEmpty() && (new StringOps(Predef$.MODULE$.augmentString(curSegmentId = this.getSegmentId((Copybook)copybook.get(), (Primitive)segmentField.get(), record))).nonEmpty() && rootSegmentIds.isEmpty() || rootSegmentIds.nonEmpty() && rootSegmentIds.contains((Object)curSegmentId))) {
                            rootRecordId = curSegmentId;
                        }
                        if (needSplit.apply$mcZIJ$sp(recordsInChunk, bytesInChunk) && (!isReallyHierarchical || this.isSegmentGoodForSplit((List<String>)rootSegmentIds, (Copybook)copybook.get(), (Primitive)segmentField.get(), record))) {
                            SparseIndexEntry indexEntry2 = new SparseIndexEntry(byteIndex, -1L, fileId, recordIndex);
                            int len = index.length();
                            SparseIndexEntry qual$1 = (SparseIndexEntry)index.apply(len - 1);
                            long x$1 = indexEntry2.offsetFrom();
                            long x$2 = qual$1.copy$default$1();
                            int x$3 = qual$1.copy$default$3();
                            long x$4 = qual$1.copy$default$4();
                            index.update(len - 1, (Object)qual$1.copy(x$2, x$1, x$3, x$4));
                            index.$plus$eq((Object)indexEntry2);
                            recordsInChunk = 0;
                            bytesInChunk = isSplitBySize ? (bytesInChunk -= (long)BoxesRunTime.unboxToInt((Object)sizePerIndexEntryMB.get()) * (long)Constants$.MODULE$.megabyte()) : 0L;
                        }
                    }
                    ++recordIndex;
                    ++recordsInChunk;
                    byteIndex += recordSize2;
                    bytesInChunk += recordSize2;
                }
                if (!isReallyHierarchical || !new StringOps(Predef$.MODULE$.augmentString(rootSegmentId)).nonEmpty() || !rootRecordId.isEmpty()) break block14;
                this.logger().error(new StringBuilder(45).append("Root segment ").append(((Primitive)segmentField.get()).name()).append("=='").append(rootSegmentId).append("' not found in the data file.").toString());
                break block15;
            }
            if (!isReallyHierarchical || !rootRecordId.isEmpty()) break block15;
            this.logger().error(new StringBuilder(57).append("Root segment ").append(((Primitive)segmentField.get()).name()).append(" ie empty for every record in the data file.").toString());
        }
        return index;
    }

    public Option<Object> sparseIndexGenerator$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> sparseIndexGenerator$default$7() {
        return None$.MODULE$;
    }

    public Option<Copybook> sparseIndexGenerator$default$8() {
        return None$.MODULE$;
    }

    public Option<Primitive> sparseIndexGenerator$default$9() {
        return None$.MODULE$;
    }

    public String sparseIndexGenerator$default$11() {
        return "";
    }

    private Function2<Object, Object, Object> getSplitCondition(Option<Object> recordsPerIndexEntry, Option<Object> sizePerIndexEntryMB) {
        long bytesPerIndexEntry = (long)BoxesRunTime.unboxToInt((Object)sizePerIndexEntryMB.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Constants$.MODULE$.defaultIndexEntrySizeMB())) * (long)Constants$.MODULE$.megabyte();
        int recPerIndexEntry = BoxesRunTime.unboxToInt((Object)recordsPerIndexEntry.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        return recordsPerIndexEntry.isDefined() ? (JFunction2.mcZIJ.sp & Serializable & scala.Serializable)(records, currentSize) -> records >= recPerIndexEntry : (JFunction2.mcZIJ.sp & Serializable & scala.Serializable)(records, currentSize) -> currentSize >= bytesPerIndexEntry;
    }

    private boolean isSegmentGoodForSplit(List<String> rootSegmentIds, Copybook copybook, Primitive segmentField, byte[] record) {
        String segmentId = this.getSegmentId(copybook, segmentField, record);
        return rootSegmentIds.contains((Object)segmentId);
    }

    private String getSegmentId(Copybook copybook, Primitive segmentIdField, byte[] data) {
        Object v = copybook.extractPrimitiveField(segmentIdField, data, copybook.extractPrimitiveField$default$3());
        return v == null ? "" : v.toString().trim();
    }

    private IndexGenerator$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

