/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.cobol.reader.stream;

import scala.reflect.ScalaSignature;
import za.co.absa.cobrix.cobol.reader.stream.SimpleStream;

@ScalaSignature(bytes="\u0006\u0001e4Aa\u0005\u000b\u0001G!AQ\u0003\u0001B\u0001B\u0003%!\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u001d9\u0004\u00011A\u0005\u0002aBq\u0001\u0010\u0001A\u0002\u0013\u0005Q\b\u0003\u0004D\u0001\u0001\u0006K!\u000f\u0005\b\t\u0002\u0001\r\u0011\"\u00019\u0011\u001d)\u0005\u00011A\u0005\u0002\u0019Ca\u0001\u0013\u0001!B\u0013I\u0004bB%\u0001\u0005\u0004%\tA\u0013\u0005\u0007#\u0002\u0001\u000b\u0011B&\t\u000bI\u0003A\u0011A*\t\u000bi\u0003A\u0011A.\t\u000b}\u0003A\u0011\u00011\t\u000b\u0011\u0004A\u0011B3\t\u000b%\u0004A\u0011\u00026\t\u000bA\u0004A\u0011B9\t\u000bQ\u0004A\u0011B;\u0003%MKW\u000e\u001d7f\u001b\u0016lwN]=TiJ,\u0017-\u001c\u0006\u0003+Y\taa\u001d;sK\u0006l'BA\f\u0019\u0003\u0019\u0011X-\u00193fe*\u0011\u0011DG\u0001\u0006G>\u0014w\u000e\u001c\u0006\u00037q\taaY8ce&D(BA\u000f\u001f\u0003\u0011\t'm]1\u000b\u0005}\u0001\u0013AA2p\u0015\u0005\t\u0013A\u0001>b\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tYC&D\u0001\u0015\u0013\tiCC\u0001\u0007TS6\u0004H.Z*ue\u0016\fW.\u0001\nm_>\\'-Y2l\u0005V4g-\u001a:TSj,\u0007CA\u00131\u0013\t\tdEA\u0002J]R\fa\u0001P5oSRtDc\u0001\u001b6mA\u00111\u0006\u0001\u0005\u0006+\r\u0001\rA\u000b\u0005\u0006]\r\u0001\raL\u0001\u0017g6\fG\u000e\\3ti\u00063\u0018-\u001b7bE2,\u0017J\u001c3fqV\t\u0011\b\u0005\u0002&u%\u00111H\n\u0002\u0005\u0019>tw-\u0001\u000et[\u0006dG.Z:u\u0003Z\f\u0017\u000e\\1cY\u0016Le\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002?\u0003B\u0011QeP\u0005\u0003\u0001\u001a\u0012A!\u00168ji\"9!)BA\u0001\u0002\u0004I\u0014a\u0001=%c\u000592/\\1mY\u0016\u001cH/\u0011<bS2\f'\r\\3J]\u0012,\u0007\u0010I\u0001\u0016Y\u0006\u0014x-Z:u\u0003Z\f\u0017\u000e\\1cY\u0016Le\u000eZ3y\u0003ea\u0017M]4fgR\fe/Y5mC\ndW-\u00138eKb|F%Z9\u0015\u0005y:\u0005b\u0002\"\t\u0003\u0003\u0005\r!O\u0001\u0017Y\u0006\u0014x-Z:u\u0003Z\f\u0017\u000e\\1cY\u0016Le\u000eZ3yA\u0005qAn\\8qE\u0006\u001c7NQ;gM\u0016\u0014X#A&\u0011\u0007\u0015be*\u0003\u0002NM\t)\u0011I\u001d:bsB\u0011QeT\u0005\u0003!\u001a\u0012AAQ=uK\u0006yAn\\8qE\u0006\u001c7NQ;gM\u0016\u0014\b%\u0001\u0005hKR\u0014\u0015\u0010^3t)\u0011yCK\u0016-\t\u000bUc\u0001\u0019A&\u0002\r\t,hMZ3s\u0011\u00159F\u00021\u0001:\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f\u0005\u000632\u0001\r!O\u0001\tK:$\u0017J\u001c3fq\u000611/Z1sG\"$2!\u000f/_\u0011\u0015iV\u00021\u0001L\u0003-\u0019X-\u0019:dQ\nKH/Z:\t\u000b]k\u0001\u0019A\u001d\u00023M,\u0017M]2i\u001fV$xJ\u001a'p_.\u0014\u0017mY6Ck\u001a4WM\u001d\u000b\u0004s\u0005\u0014\u0007\"B/\u000f\u0001\u0004Y\u0005\"B2\u000f\u0001\u0004y\u0013AE5oSRL\u0017\r\\*fCJ\u001c\u0007n\u0015;bi\u0016\f\u0001$\u001b8ji&\fG.\u0012=ue\u0006\u001cGO\u0012:p[N#(/Z1n)\u0011ycm\u001a5\t\u000bU{\u0001\u0019A&\t\u000b]{\u0001\u0019A\u001d\t\u000be{\u0001\u0019A\u001d\u0002=\u0015DHO]1di>+Ho\u00144M_>\u0014\u0017mY6Ck\u001a4WM\u001d\"zi\u0016\u001cH#B\u0018lY6t\u0007\"B+\u0011\u0001\u0004Y\u0005\"B,\u0011\u0001\u0004I\u0004\"B-\u0011\u0001\u0004I\u0004\"B8\u0011\u0001\u0004y\u0013aD1eI&$\u0018n\u001c8bY\nKH/Z:\u00021\u0005#GMQ=uKN$v\u000eT8pW\n\f7m\u001b\"vM\u001a,'\u000f\u0006\u0002?e\")1/\u0005a\u0001\u0017\u0006\u0019\u0011M\u001d:\u0002=\u0015DHO]1di\nKH/Z:Ge>lGj\\8lE\u0006\u001c7NQ;gM\u0016\u0014H\u0003B\u0018wobDQ!\u0016\nA\u0002-CQa\u0016\nA\u0002eBQ!\u0017\nA\u0002e\u0002")
public class SimpleMemoryStream {
    private final SimpleStream stream;
    private final int lookbackBufferSize;
    private long smallestAvailableIndex;
    private long largestAvailableIndex;
    private final byte[] loopbackBuffer;

    public long smallestAvailableIndex() {
        return this.smallestAvailableIndex;
    }

    public void smallestAvailableIndex_$eq(long x$1) {
        this.smallestAvailableIndex = x$1;
    }

    public long largestAvailableIndex() {
        return this.largestAvailableIndex;
    }

    public void largestAvailableIndex_$eq(long x$1) {
        this.largestAvailableIndex = x$1;
    }

    public byte[] loopbackBuffer() {
        return this.loopbackBuffer;
    }

    public int getBytes(byte[] buffer, long startIndex, long endIndex) {
        int additionalBytes;
        if (startIndex < this.smallestAvailableIndex()) {
            throw new IllegalStateException("The index is too small: $startIndex < $smallestAvailableIndex. Please increase the lookback buffer size.");
        }
        if (endIndex < startIndex) {
            throw new IllegalStateException(new StringBuilder(28).append("Illegal indexes passed: ").append(endIndex).append(" < ").append(startIndex).append(".").toString());
        }
        return this.largestAvailableIndex() < 0L ? this.initialExtractFromStream(buffer, startIndex, endIndex) : ((additionalBytes = (int)(endIndex - this.largestAvailableIndex())) > 0 ? this.extractOutOfLoobackBufferBytes(buffer, startIndex, endIndex, additionalBytes) : this.extractBytesFromLookbackBuffer(buffer, startIndex, endIndex));
    }

    public long search(byte[] searchBytes, long startIndex) {
        int state = 0;
        if (startIndex < this.smallestAvailableIndex()) {
            throw new IllegalStateException("The index is too small: $startIndex < $smallestAvailableIndex. Please increase the lookback buffer size.");
        }
        int bytesSearched = 0;
        long i = startIndex;
        while (state < searchBytes.length && i <= this.largestAvailableIndex()) {
            state = this.loopbackBuffer()[(int)(i - this.smallestAvailableIndex())] == searchBytes[state] ? ++state : 0;
            ++i;
            ++bytesSearched;
        }
        return state == searchBytes.length ? i - (long)searchBytes.length : this.searchOutOfLookbackBuffer(searchBytes, state);
    }

    public long searchOutOfLookbackBuffer(byte[] searchBytes, int initialSearchState) {
        int state = initialSearchState;
        int bytesRead = 1;
        int addsize = this.lookbackBufferSize / 2;
        byte[] buf = new byte[addsize];
        long i = this.largestAvailableIndex() + 1L;
        while (state < searchBytes.length && bytesRead > 0) {
            bytesRead = this.getBytes(buf, i, i + (long)addsize - 1L);
            if (bytesRead <= 0) continue;
            for (int j = 0; state < searchBytes.length && j < bytesRead; ++j) {
                state = buf[j] == searchBytes[state] ? ++state : 0;
                ++i;
            }
        }
        return state == searchBytes.length ? i - (long)searchBytes.length : -1L;
    }

    private int initialExtractFromStream(byte[] buffer, long startIndex, long endIndex) {
        byte[] arr = this.stream.next((int)endIndex + 1);
        this.smallestAvailableIndex_$eq(0L);
        this.largestAvailableIndex_$eq(endIndex);
        int i = 0;
        while ((long)i <= endIndex) {
            this.loopbackBuffer()[i] = arr[i];
            ++i;
        }
        i = 0;
        while ((long)i < endIndex - startIndex + 1L) {
            buffer[i] = this.loopbackBuffer()[(int)(startIndex + (long)i)];
            ++i;
        }
        return (int)(endIndex - startIndex) + 1;
    }

    private int extractOutOfLoobackBufferBytes(byte[] buffer, long startIndex, long endIndex, int additionalBytes) {
        byte[] arr = this.stream.next(additionalBytes);
        int actualBytes = arr.length;
        for (long i = startIndex; i <= endIndex && i <= this.largestAvailableIndex() + (long)actualBytes; ++i) {
            if (i <= this.largestAvailableIndex()) {
                buffer[(int)(i - startIndex)] = this.loopbackBuffer()[(int)(i - this.smallestAvailableIndex())];
                continue;
            }
            long j = i - this.largestAvailableIndex() - 1L;
            buffer[(int)(i - startIndex)] = arr[(int)j];
        }
        this.AddBytesToLookbackBuffer(arr);
        return (int)(Math.min(this.largestAvailableIndex(), endIndex) - startIndex) + 1;
    }

    private void AddBytesToLookbackBuffer(byte[] arr) {
        block3: {
            block2: {
                if (this.largestAvailableIndex() + this.smallestAvailableIndex() + (long)arr.length >= (long)this.lookbackBufferSize) break block2;
                for (int j = 0; j < arr.length; ++j) {
                    this.loopbackBuffer()[(int)(this.largestAvailableIndex() - this.smallestAvailableIndex()) + j + 1] = arr[j];
                }
                this.largestAvailableIndex_$eq(this.largestAvailableIndex() + (long)arr.length);
                break block3;
            }
            long newLargestIndex = this.largestAvailableIndex() + (long)arr.length;
            long newSmallestIndex = newLargestIndex - (long)this.lookbackBufferSize + 1L;
            if (newLargestIndex == this.largestAvailableIndex() || newSmallestIndex == this.smallestAvailableIndex()) break block3;
            for (long i = newSmallestIndex; i <= newLargestIndex; ++i) {
                this.loopbackBuffer()[(int)(i - newSmallestIndex)] = i <= this.largestAvailableIndex() ? this.loopbackBuffer()[(int)(i - this.smallestAvailableIndex())] : arr[(int)(i - this.largestAvailableIndex() - 1L)];
            }
            this.smallestAvailableIndex_$eq(newSmallestIndex);
            this.largestAvailableIndex_$eq(newLargestIndex);
        }
    }

    private int extractBytesFromLookbackBuffer(byte[] buffer, long startIndex, long endIndex) {
        int i = 0;
        while ((long)i <= endIndex - startIndex) {
            buffer[i] = this.loopbackBuffer()[(int)(startIndex - this.smallestAvailableIndex() + (long)i)];
            ++i;
        }
        return (int)(endIndex - startIndex) + 1;
    }

    public SimpleMemoryStream(SimpleStream stream, int lookbackBufferSize) {
        this.stream = stream;
        this.lookbackBufferSize = lookbackBufferSize;
        this.smallestAvailableIndex = -1L;
        this.largestAvailableIndex = -1L;
        this.loopbackBuffer = new byte[lookbackBufferSize];
    }
}

