/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.cobol.parser.decoders;

import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class BCDNumberDecoders$ {
    public static BCDNumberDecoders$ MODULE$;

    static {
        new BCDNumberDecoders$();
    }

    public Long decodeBCDIntegralNumber(byte[] bytes) {
        if (bytes.length < 1) {
            return null;
        }
        int sign = 1;
        long outputNumber = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int lowNibble = b & 0xF;
            int highNibble = b >> 4 & 0xF;
            if (highNibble < 0 || highNibble >= 10) {
                return null;
            }
            outputNumber = outputNumber * 10L + (long)highNibble;
            if (i + 1 == bytes.length) {
                int n;
                int n2 = lowNibble;
                switch (n2) {
                    case 12: {
                        n = 1;
                        break;
                    }
                    case 13: {
                        n = -1;
                        break;
                    }
                    case 15: {
                        n = 1;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                sign = n;
                continue;
            }
            if (lowNibble >= 0 && lowNibble < 10) {
                outputNumber = outputNumber * 10L + (long)lowNibble;
                continue;
            }
            return null;
        }
        return Predef$.MODULE$.long2Long((long)sign * outputNumber);
    }

    public String decodeBigBCDNumber(byte[] bytes, int scale, int scaleFactor) {
        String string;
        int i;
        if (scale < 0) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Invalid scale=").append(scale).append(", should be greater or equal to zero.").toString());
        }
        if (bytes.length < 1) {
            return null;
        }
        String sign = "";
        int intendedDecimalPosition = bytes.length * 2 - (scale + 1);
        int additionalZeros = intendedDecimalPosition <= 0 ? -intendedDecimalPosition + 1 : 0;
        StringBuffer chars = new StringBuffer(bytes.length * 2 + 2 + additionalZeros);
        int decimalPointPosition = bytes.length * 2 - (scale + 1) + additionalZeros;
        for (i = 0; i < additionalZeros; ++i) {
            chars.append('0');
        }
        for (i = 0; i < bytes.length; ++i) {
            Object object;
            byte b = bytes[i];
            int lowNibble = b & 0xF;
            int highNibble = b >> 4 & 0xF;
            if (highNibble < 0 || highNibble >= 10) {
                return null;
            }
            chars.append((char)((byte)48 + highNibble));
            if (i + 1 == bytes.length) {
                String string2;
                int n = lowNibble;
                switch (n) {
                    case 12: {
                        string2 = "";
                        break;
                    }
                    case 13: {
                        string2 = "-";
                        break;
                    }
                    case 15: {
                        string2 = "";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                sign = string2;
                object = BoxedUnit.UNIT;
                continue;
            }
            if (lowNibble >= 0 && lowNibble < 10) {
                object = chars.append((char)((byte)48 + lowNibble));
                continue;
            }
            return null;
        }
        if (scaleFactor == 0) {
            Object object = scale > 0 ? chars.insert(decimalPointPosition, '.') : BoxedUnit.UNIT;
            chars.insert(0, sign);
            string = chars.toString();
        } else if (scaleFactor < 0) {
            String zeros = new StringOps(Predef$.MODULE$.augmentString("0")).$times(-scaleFactor);
            string = new StringBuilder(2).append(sign).append("0.").append(zeros).append(chars.toString()).toString();
        } else {
            String zeros = new StringOps(Predef$.MODULE$.augmentString("0")).$times(scaleFactor);
            chars.insert(0, sign);
            string = new StringBuilder(0).append(chars.toString()).append(zeros).toString();
        }
        return string;
    }

    public BigDecimal decodeBigBCDDecimal(byte[] binBytes, int scale, int scaleFactor) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(this.decodeBigBCDNumber(binBytes, scale, scaleFactor));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_7 = null;
            bigDecimal = var4_7;
        }
        return bigDecimal;
    }

    private BCDNumberDecoders$() {
        MODULE$ = this;
    }
}

