/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.cobol.parser.decoders;

import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scodec.Codec;
import scodec.DecodeResult;
import scodec.bits.BitVector$;
import scodec.codecs.package$;

public final class FloatingPointDecoders$ {
    public static FloatingPointDecoders$ MODULE$;
    private final Codec<Object> floatB;
    private final Codec<Object> floatL;
    private final Codec<Object> doubleB;
    private final Codec<Object> doubleL;
    private final long BIT_COUNT_MAGIC;

    static {
        new FloatingPointDecoders$();
    }

    private Codec<Object> floatB() {
        return this.floatB;
    }

    private Codec<Object> floatL() {
        return this.floatL;
    }

    private Codec<Object> doubleB() {
        return this.doubleB;
    }

    private Codec<Object> doubleL() {
        return this.doubleL;
    }

    private long BIT_COUNT_MAGIC() {
        return this.BIT_COUNT_MAGIC;
    }

    public Float decodeIeee754SingleBigEndian(byte[] bytes) {
        Float f;
        try {
            f = Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)((DecodeResult)this.floatB().decode(BitVector$.MODULE$.apply(bytes)).require()).value()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var2_5 = null;
            f = var2_5;
        }
        return f;
    }

    public Double decodeIeee754DoubleBigEndian(byte[] bytes) {
        Double d;
        try {
            d = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)((DecodeResult)this.doubleB().decode(BitVector$.MODULE$.apply(bytes)).require()).value()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var2_5 = null;
            d = var2_5;
        }
        return d;
    }

    public Float decodeIeee754SingleLittleEndian(byte[] bytes) {
        Float f;
        try {
            f = Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)((DecodeResult)this.floatL().decode(BitVector$.MODULE$.apply(bytes)).require()).value()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var2_5 = null;
            f = var2_5;
        }
        return f;
    }

    public Double decodeIeee754DoubleLittleEndian(byte[] bytes) {
        Double d;
        try {
            d = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)((DecodeResult)this.doubleL().decode(BitVector$.MODULE$.apply(bytes)).require()).value()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var2_5 = null;
            d = var2_5;
        }
        return d;
    }

    public Float decodeIbmSingleBigEndian(byte[] bytes) {
        Float f;
        block8: {
            try {
                int IBM32_SIGN_MASK = Integer.MIN_VALUE;
                int IBM32_EXPONENT_MASK = Integer.MIN_VALUE;
                int IBM32_FRACTURE_MASK = 0xFFFFFF;
                int IBM32_MS_NIBBLE = 0xF00000;
                int mantissa = bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
                int sign = mantissa & IBM32_SIGN_MASK;
                int fracture = mantissa & IBM32_FRACTURE_MASK;
                int exponent = (mantissa & IBM32_EXPONENT_MASK) >> 22;
                if ((long)fracture == 0L) {
                    f = Predef$.MODULE$.float2Float(0.0f);
                    break block8;
                }
                int topNibble = fracture & IBM32_MS_NIBBLE;
                while (topNibble == 0) {
                    exponent -= 4;
                    topNibble = (fracture <<= 4) & IBM32_MS_NIBBLE;
                }
                int leadingZeros = (int)(this.BIT_COUNT_MAGIC() >> (topNibble >> 19) & 3L);
                fracture <<= leadingZeros;
                int convertedExp = exponent + 131 - leadingZeros;
                if (convertedExp >= 0 && convertedExp < 254) {
                    int ieee754Int = sign + (convertedExp << 23) + fracture;
                    f = Predef$.MODULE$.float2Float(Float.intBitsToFloat(ieee754Int));
                    break block8;
                }
                if (convertedExp > 254) {
                    f = Predef$.MODULE$.float2Float(Float.POSITIVE_INFINITY);
                    break block8;
                }
                if (convertedExp >= -32) {
                    int mask = ~(-3 << -1 - convertedExp);
                    int roundUp = (fracture & mask) > 0 ? 1 : 0;
                    int convertedFract = (fracture >> -1 - convertedExp) + roundUp >> 1;
                    int ieee754Int = sign + convertedFract;
                    f = Predef$.MODULE$.float2Float(Float.intBitsToFloat(ieee754Int));
                    break block8;
                }
                f = Predef$.MODULE$.float2Float(0.0f);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Float f2 = null;
                f = f2;
            }
        }
        return f;
    }

    public Double decodeIbmDoubleBigEndian(byte[] bytes) {
        Double d;
        block5: {
            try {
                long IBM64_SIGN_MASK = Long.MIN_VALUE;
                long IBM64_EXPONENT_MASK = 0x7F00000000000000L;
                long IBM64_FRACTURE_MASK = 0xFFFFFFFFFFFFFFL;
                long IBM64_MS_NIBBLE = 0xF0000000000000L;
                long mantissa = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
                long sign = mantissa & IBM64_SIGN_MASK;
                long fracture = mantissa & IBM64_FRACTURE_MASK;
                long exponent = (mantissa & IBM64_EXPONENT_MASK) >> 54;
                if (fracture == 0L) {
                    d = Predef$.MODULE$.double2Double(0.0);
                    break block5;
                }
                long topNibble = fracture & IBM64_MS_NIBBLE;
                while (topNibble == 0L) {
                    exponent -= 4L;
                    topNibble = (fracture <<= 4) & IBM64_MS_NIBBLE;
                }
                long leadingZeros = this.BIT_COUNT_MAGIC() >> (int)(topNibble >> 51) & 3L;
                long convertedExp = exponent + 765L - leadingZeros;
                int roundUp = ((fracture <<= (int)leadingZeros) & 0xBL) > 0L ? 1 : 0;
                long convertedFract = (fracture >> 2) + (long)roundUp >> 1;
                long ieee754Long = sign + (convertedExp << 52) + convertedFract;
                d = Predef$.MODULE$.double2Double(Double.longBitsToDouble(ieee754Long));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Double d2 = null;
                d = d2;
            }
        }
        return d;
    }

    public Float decodeIbmSingleLittleEndian(byte[] bytes) {
        return this.decodeIbmSingleBigEndian((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).reverse());
    }

    public Double decodeIbmDoubleLittleEndian(byte[] bytes) {
        return this.decodeIbmDoubleBigEndian((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).reverse());
    }

    private FloatingPointDecoders$() {
        MODULE$ = this;
        this.floatB = package$.MODULE$.float();
        this.floatL = package$.MODULE$.floatL();
        this.doubleB = package$.MODULE$.double();
        this.doubleL = package$.MODULE$.doubleL();
        this.BIT_COUNT_MAGIC = 21935L;
    }
}

