/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.utils;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import za.co.absa.cobrix.cobol.internal.Logging;

public final class FileUtils$
implements Logging {
    public static FileUtils$ MODULE$;
    private final int THRESHOLD_DIR_LENGTH_FOR_SINGLE_FILE_CHECK;
    private final PathFilter hiddenFileFilter;
    private transient Logger za$co$absa$cobrix$cobol$internal$Logging$$log_;

    static {
        new FileUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public Logger za$co$absa$cobrix$cobol$internal$Logging$$log_() {
        return this.za$co$absa$cobrix$cobol$internal$Logging$$log_;
    }

    public void za$co$absa$cobrix$cobol$internal$Logging$$log__$eq(Logger x$1) {
        this.za$co$absa$cobrix$cobol$internal$Logging$$log_ = x$1;
    }

    public int THRESHOLD_DIR_LENGTH_FOR_SINGLE_FILE_CHECK() {
        return this.THRESHOLD_DIR_LENGTH_FOR_SINGLE_FILE_CHECK;
    }

    private PathFilter hiddenFileFilter() {
        return this.hiddenFileFilter;
    }

    public List<String> getFiles(String dir, Configuration hadoopConf, boolean recursive) {
        return this.getFiles(dir, new Path(dir).getFileSystem(hadoopConf), recursive);
    }

    public List<String> getFiles(String dir, FileSystem fileSystem, boolean recursive) {
        Path dirPath = new Path(dir);
        FileStatus[] stats = fileSystem.globStatus(dirPath, this.hiddenFileFilter());
        if (stats == null) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Input path does not exist: ").append(dir).toString());
        }
        FileStatus[] allFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stats)).flatMap((Function1 & Serializable & scala.Serializable)stat -> stat.isDirectory() ? (recursive ? MODULE$.getAllFiles(stat.getPath(), fileSystem) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem.listStatus(stat.getPath(), MODULE$.hiddenFileFilter()))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.$anonfun$getFiles$2(x$1)))))) : new Seq<FileStatus>(stat, (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
    }

    public boolean getFiles$default$3() {
        return false;
    }

    public void writeStringToFile(String string, String filePathName) {
        try (PrintWriter writer = new PrintWriter(filePathName);){
            writer.write(string);
        }
    }

    public void writeStringToUtf8File(String string, String filePathName) {
        OutputStreamWriter utf8Output = new OutputStreamWriter((OutputStream)new FileOutputStream(filePathName), StandardCharsets.UTF_8);
        try (PrintWriter writer = new PrintWriter(utf8Output);){
            writer.write(string);
        }
    }

    public void writeStringsToFile(String[] strings, String filePathName) {
        try (PrintWriter writer = new PrintWriter(filePathName, "UTF-8");){
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])strings)).foreach((Function1 & Serializable & scala.Serializable)str -> {
                FileUtils$.$anonfun$writeStringsToFile$1(writer, str);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void writeStringsToUtf8File(String[] strings, String filePathName) {
        OutputStreamWriter utf8Output = new OutputStreamWriter((OutputStream)new FileOutputStream(filePathName), StandardCharsets.UTF_8);
        try (PrintWriter writer = new PrintWriter(utf8Output);){
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])strings)).foreach((Function1 & Serializable & scala.Serializable)str -> {
                FileUtils$.$anonfun$writeStringsToUtf8File$1(writer, str);
                return BoxedUnit.UNIT;
            });
        }
    }

    public String readAllFileLines(String fileName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.ISO_8859_1).toArray())).mkString("\n");
    }

    public String readAllFileStringUtf8(String fileName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8).toArray())).mkString("\n");
    }

    public String[] readAllFileLinesUtf8(String fileName) {
        return (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private Seq<FileStatus> getAllFiles(Path dir, FileSystem fileSystem) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem.listStatus(dir, this.hiddenFileFilter()))).flatMap((Function1 & Serializable & scala.Serializable)stat -> stat.isDirectory() ? MODULE$.getAllFiles(stat.getPath(), fileSystem) : (Seq)new .colon.colon(stat, (List)Nil$.MODULE$), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public int getNumberOfFilesInDir(String directory, FileSystem fileSystem) {
        return this.expandDirectories(fileSystem, fileSystem.globStatus(new Path(directory), this.hiddenFileFilter())).length;
    }

    public boolean findAndLogFirstNonDivisibleFile(String sourceDir, long divisor, FileSystem fileSystem) {
        Option firstNonDivisibleFile;
        block0: {
            FileStatus[] allFiles = this.expandDirectories(fileSystem, fileSystem.globStatus(new Path(sourceDir), this.hiddenFileFilter()));
            firstNonDivisibleFile = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).take(this.THRESHOLD_DIR_LENGTH_FOR_SINGLE_FILE_CHECK()))).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.MODULE$.isNonDivisible(x$3, divisor)));
            if (!firstNonDivisibleFile.isDefined()) break block0;
            this.logger().error(new StringBuilder(35).append("File ").append(((FileStatus)firstNonDivisibleFile.get()).getPath()).append(" size (").append(((FileStatus)firstNonDivisibleFile.get()).getLen()).append(") IS NOT divisible by ").append(divisor).append(".").toString());
        }
        return firstNonDivisibleFile.isDefined();
    }

    public long findAndLogAllNonDivisibleFiles(String sourceDir, long divisor, FileSystem fileSystem) {
        FileStatus[] allNonDivisibleFiles;
        block0: {
            FileStatus[] allFiles = this.expandDirectories(fileSystem, fileSystem.globStatus(new Path(sourceDir), this.hiddenFileFilter()));
            allNonDivisibleFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.MODULE$.isNonDivisible(x$4, divisor)));
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allNonDivisibleFiles)).nonEmpty()) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allNonDivisibleFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                FileUtils$.$anonfun$findAndLogAllNonDivisibleFiles$2(divisor, file);
                return BoxedUnit.UNIT;
            });
        }
        return allNonDivisibleFiles.length;
    }

    private boolean isNonDivisible(FileStatus fileStatus, long divisor) {
        return fileStatus.getLen() % divisor != 0L;
    }

    private FileStatus[] expandDirectories(FileSystem fileSystem, FileStatus[] filesAndDirs) {
        return (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesAndDirs)).flatMap((Function1 & Serializable & scala.Serializable)fileStatus -> new ArrayOps.ofRef(FileUtils$.$anonfun$expandDirectories$1(fileSystem, fileStatus)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
    }

    public static final /* synthetic */ boolean $anonfun$getFiles$2(FileStatus x$1) {
        return !x$1.isDirectory();
    }

    public static final /* synthetic */ void $anonfun$writeStringsToFile$1(PrintWriter writer$1, String str) {
        writer$1.write(str);
        writer$1.write("\n");
    }

    public static final /* synthetic */ void $anonfun$writeStringsToUtf8File$1(PrintWriter writer$2, String str) {
        writer$2.write(str);
        writer$2.write("\n");
    }

    public static final /* synthetic */ void $anonfun$findAndLogAllNonDivisibleFiles$2(long divisor$2, FileStatus file) {
        MODULE$.logger().error(new StringBuilder(35).append("File ").append(file.getPath()).append(" size (").append(file.getLen()).append(") IS NOT divisible by ").append(divisor$2).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$expandDirectories$2(FileStatus x$5) {
        return !x$5.isDirectory();
    }

    public static final /* synthetic */ Object[] $anonfun$expandDirectories$1(FileSystem fileSystem$3, FileStatus fileStatus) {
        Object[] objectArray;
        if (fileStatus.isDirectory()) {
            Path newPath = new Path(fileStatus.getPath(), "*");
            objectArray = Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem$3.globStatus(newPath, MODULE$.hiddenFileFilter()))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.$anonfun$expandDirectories$2(x$5))));
        } else {
            objectArray = Predef$.MODULE$.refArrayOps((Object[])new FileStatus[]{fileStatus});
        }
        return objectArray;
    }

    private FileUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.THRESHOLD_DIR_LENGTH_FOR_SINGLE_FILE_CHECK = 50;
        this.hiddenFileFilter = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
    }
}

