/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.utils;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HDFSUtils$ {
    public static HDFSUtils$ MODULE$;

    static {
        new HDFSUtils$();
    }

    public final int bytesInMegabyte() {
        return 0x100000;
    }

    public Seq<String> getBlocksLocations(Path path, FileSystem fileSystem) {
        return this.getBlocksLocations(path, 0L, Long.MAX_VALUE, fileSystem);
    }

    public Seq<String> getBlocksLocations(Path path, long start, long length, FileSystem fileSystem) {
        if (start < 0L || length <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Invalid offset or length: offset = ").append(start).append(", length = ").append(length).toString());
        }
        if (fileSystem.getFileStatus(path).isDirectory()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Should be a file, not a directory: ").append(path.getName()).toString());
        }
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem.getFileBlockLocations(fileSystem.getFileStatus(path), start, length))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.getHosts())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct());
    }

    public Option<Object> getHDFSDefaultBlockSizeMB(FileSystem fileSystem, Option<String> path) {
        int blockSizeInBM;
        Path hdfsPath = new Path((String)path.getOrElse((Function0 & Serializable & scala.Serializable)() -> "/"));
        long blockSizeInBytes = fileSystem.getDefaultBlockSize(hdfsPath);
        return blockSizeInBytes > 0L ? ((blockSizeInBM = (int)(blockSizeInBytes / 0x100000L)) > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)blockSizeInBM)) : None$.MODULE$) : None$.MODULE$;
    }

    public Option<String> getHDFSDefaultBlockSizeMB$default$2() {
        return None$.MODULE$;
    }

    public String loadTextFileFromHadoop(Configuration hadoopConfiguration, String copyBookHadoopPath) {
        String string;
        Path copybookPath = new Path(copyBookHadoopPath);
        FileSystem hdfs = copybookPath.getFileSystem(hadoopConfiguration);
        try (FSDataInputStream stream = hdfs.open(copybookPath);){
            string = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8)).asScala()).mkString("\n");
        }
        return string;
    }

    private HDFSUtils$() {
        MODULE$ = this;
    }
}

